import * as React from 'react';

import { EMPTY_VALUE } from '../../_models';
import { AutoGrowTextArea } from '../../form_inputs';
import { classNames } from '../../formatters';
import { Rows } from '../../small_components';
import { autobind } from '../../utils';
import { FieldLayout } from '../components/FieldLayout';
import { IFieldProps } from '../models';

import classes from './fields.module.css';

export class TextField extends React.PureComponent<IFieldProps<string>> {
   public static displayName = 'TextField';

   public render() {
      return (
         <FieldLayout config={this.props.config} help={this.props.help} error={this.props.error}>
            {this.props.readonly ? (
               <Rows text={this.props.value || EMPTY_VALUE} />
            ) : (
               <AutoGrowTextArea
                  className={classNames({ [classes.error]: Boolean(this.props.error) })}
                  disabled={this.props.disabled}
                  hasClear={true}
                  name={this.props.config.name}
                  onUpdate={this.onChange}
                  placeholder={this.props.config.placeholder}
                  value={this.props.value}
               />
            )}
         </FieldLayout>
      );
   }

   @autobind
   private onChange(value: string) {
      this.props.onChange(null, value);
   }
}
