/**
 * Поддерживаемые типы полей
 * @file
 */

import { ComponentType } from 'react';

import { IValueProps } from '../_models';

export interface IEnumOption {
   title: string;
   value: string;
}

export enum FormFieldType {
   /**
    * Одна галочка (чекбокс)
    */
   Boolean = 'boolean',

   /**
    * То же самое, что и Boolean, но используется компонент переключатель, а не чекбокс
    */
   BooleanSwitcher = 'booleanSwitcher',

   /**
    * Особый тип - позволяет указывать свой компонент для рендеринга поля
    * (в конфиге обязательно должно быть поле component c адаптированным компонентом)
    */
   Custom = 'custom',

   /**
    * Дата (без времени).
    *
    * Время будет установлено в 0:00 по ЛОКАЛЬНОМУ времени.
    * Для московского часового пояса это значит, что значение в UTC будет 21:00 предыдущего дня.
    */
   Date = 'date',

   /**
    * Выбор из нескольких вариантов
    */
   Enum = 'enum',

   /**
    * Невидимое поле (просто для хранения значения)
    */
   Hidden = 'hidden',

   /**
    * Дата (со временем)
    */
   DateTime = 'datetime',

   /**
    * Число
    */
   Number = 'number',

   /**
    * Большое поле для ввода уникальных чисел
    */
   NumberSet = 'numberSet',

   /**
    * Обычное текстовое поле (однострочное)
    */
   String = 'string',

   /**
    * Большое поле для ввода уникальных строк (например списка хостов)
    *
    * Пустые строки игнорируются.
    */
   StringSet = 'stringSet',

   /**
    * Многострочный текст (отображается <textarea rows=5/>)
    */
   Text = 'text',
}

export interface IFormField<T = {}> {
   checkboxLabel?: string;
   component?: ComponentType<IFieldProps<any>>;
   hint?: string;
   label?: string;
   name: keyof T;
   options?: IEnumOption[];
   placeholder?: string;
   required?: boolean;
   separator?: RegExp;
   subConfig?: any;
   type: FormFieldType;
   validationField?: keyof T;

   isDisabled?(params: T, context?: any): boolean;

   isHidden?(params: T, context?: any): boolean;

   getError?(params: T, context?: any): string | null;

   getHelp?(params: T, context?: any): string | null;
}

export interface IFieldProps<V, C = any> extends IValueProps<V> {
   config: IFormField;
   context?: C;
   disabled: boolean;
   error?: string | null;
   formValue?: object;
   help?: string | null;
   readonly: boolean;
}
