import { FormFieldType, IFormField } from './models';
import { clearParams } from './utils';

describe('forms|utils', () => {
   describe('clearParams', () => {
      it('should remove NaN', () => {
         const fields: IFormField<any>[] = [
            { name: 'x', type: FormFieldType.Number },
            { name: 'y', type: FormFieldType.Number },
         ];

         expect(clearParams(fields, { x: Number.NaN, y: 3 })).toEqual({ y: 3 });
      });
   });
});
