import { isEmpty } from '../helpers';

import { IFormField } from './models';

export function clearParams<T>(fields: IFormField<T>[], params: T, context?: any): Partial<T> {
   const map = new Map(fields.map(config => [config.name, config]));

   return Object.keys(params).reduce((acc, field) => {
      if (field.startsWith('_')) {
         return acc;
      }

      const value = typeof params[field] === 'string' ? params[field].trim() : params[field];

      if (isEmpty(value)) {
         return acc;
      }

      const fieldConfig = map.get(field as keyof T);

      if (!fieldConfig) {
         return acc;
      }

      if (fieldConfig.isHidden && fieldConfig.isHidden(params, context)) {
         return acc;
      }

      if (fieldConfig.isDisabled && fieldConfig.isDisabled(params, context)) {
         return acc;
      }

      acc[field] = value;

      return acc;
   }, {} as Partial<T>);
}
