import { faHeart } from '@fortawesome/free-solid-svg-icons';
import { action } from '@storybook/addon-actions';
import { ComponentMeta, Story } from '@storybook/react';
import React, { PropsWithChildren } from 'react';

import { AddButton, AddButtonProps } from './AddButton';

const Template: Story<PropsWithChildren<AddButtonProps>> = ({ children, ...props }) => (
   <AddButton {...props}>{children}</AddButton>
);

export const Regular = Template.bind({});
Regular.args = {};

export const Disabled = Template.bind({});
Disabled.args = {
   children: 'Disabled button',
   disabled: true,
};

export const CustomIcon = Template.bind({});
CustomIcon.args = {
   icon: faHeart,
};

export default {
   args: {
      children: 'Button text',
      onClick: action('onClick'),
   },
   component: AddButton,
   title: 'forms2/components/AddButton',
} as ComponentMeta<typeof AddButton>;
