import { IconDefinition } from '@fortawesome/fontawesome-common-types';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button, ButtonView } from '@yandex-cloud/uikit';
import React, { SyntheticEvent } from 'react';

import { faPlus } from '../../../_styles/@fortawesome/pro-regular-svg-icons';
import { classNames, createE2eSelector } from '../../../formatters';

import classes from './AddButton.module.css';

export interface AddButtonProps {
   className?: string;
   disabled?: boolean;
   icon?: IconDefinition;
   qa?: string;

   title?: string;
   view?: ButtonView;

   onClick(e: SyntheticEvent): void;
}

export const AddButton: React.FC<AddButtonProps> = ({
   children,
   className,
   disabled,
   icon = faPlus,
   onClick,
   qa,
   title,
   view = 'outlined',
}) => (
   <Button
      className={classNames(classes.button, className)}
      disabled={disabled}
      onClick={onClick}
      qa={createE2eSelector(qa, title, typeof children === 'string' ? children : null, 'AddButton')}
      size={'s'}
      title={title}
      view={view}
   >
      {icon ? <FontAwesomeIcon icon={icon} className={classes.icon} /> : null}
      {children}
   </Button>
);

AddButton.displayName = 'AddButton';
