import { Field } from 'formik';
import React from 'react';

import { classNames } from '../../../formatters';
import { ExtendedFieldConfig } from '../../models';

interface Props<T> {
   configs: ExtendedFieldConfig<T>[] | undefined;
   defaults?: Partial<ExtendedFieldConfig<T>>;
   fieldClassName?: string;
   overrides?: Partial<ExtendedFieldConfig<T>>;
}

export const DeclarativeFields = <T extends {}>({ configs, defaults, fieldClassName, overrides }: Props<T>) => (
   <>
      {(configs ?? []).map(config => (
         <Field
            key={config.key ?? String(config.name)}
            {...defaults}
            {...config}
            {...overrides}
            className={classNames(config.className, fieldClassName)}
         />
      ))}
   </>
);

DeclarativeFields.displayName = 'DeclarativeFields';
