import { useFormikContext } from 'formik';
import React from 'react';

import { DevJson } from '../../../small_components';

interface DevFormProps {
   open?: boolean;
}

/**
 * Отображает состояние формы (значения полей, валидации и проч.)
 */
export function DevForm({ open }: DevFormProps) {
   const form = useFormikContext<any>();

   return (
      <DevJson summary={'Form state'} open={open}>
         {form}
      </DevJson>
   );
}

export function DevFormValues({ open }: DevFormProps) {
   const form = useFormikContext<any>();

   return (
      <DevJson summary={'Form values'} open={open ?? true}>
         {form.values}
      </DevJson>
   );
}
