import React from 'react';

import { Rows } from '../../../small_components';

type YupError = string | { [k: string]: YupError };

function getErrors(error: YupError): string[] {
   const result: string[] = [];

   switch (typeof error) {
      case 'string':
         result.push(error);
         break;

      case 'object':
         for (const field in error) {
            if (error.hasOwnProperty(field)) {
               const e = error[field];
               if (typeof e === 'string') {
                  result.push(e);
               } else {
                  result.push(...getErrors(e));
               }
            }
         }
         break;

      default:
         break;
   }

   return result;
}

interface Props {
   children: YupError;
}

export const FieldError: React.FC<Props> = ({ children: error }) => (error ? <Rows text={getErrors(error)} /> : null);
