import { action } from '@storybook/addon-actions';
import { ComponentMeta, Story } from '@storybook/react';
import { TextInput } from '@yandex-cloud/uikit';
import { Formik } from 'formik';
import React from 'react';

import { ExtendedFieldConfig } from '../../models';

import { FieldLayout } from './FieldLayout';

const Template: Story<ExtendedFieldConfig> = props => {
   return (
      <Formik initialValues={{}} onSubmit={action('onSubmit')}>
         {form => (
            <FieldLayout {...props}>
               <TextInput
                  name={props.name as string}
                  value={form.values[props.name]}
                  onBlur={form.handleBlur}
                  onChange={form.handleChange}
               />
            </FieldLayout>
         )}
      </Formik>
   );
};

export const Regular = Template.bind({});
Regular.args = {};

export const BigLabel = Template.bind({});
BigLabel.args = { bigLabel: true };

export const ReadonlyDots = Template.bind({});
ReadonlyDots.args = { readonly: true, readonlyDots: true };

export const CustomLabel = Template.bind({});
CustomLabel.args = {
   label: (
      <span style={{ color: 'seagreen' }}>
         custom <b>label</b>
      </span>
   ),
};

export default {
   component: FieldLayout,
   title: 'forms2/components/FieldLayout',
   args: {
      'data-test': 'test-selector',
      bigLabel: false,
      disabled: false,
      help: 'This is help',
      hidden: false,
      hideErrors: false,
      hint: 'This is a hint. This is a hint. This is a hint. This is a hint. This is a hint. This is a hint.',
      label: 'Label',
      labelClassName: '',
      name: 'test',
      readonly: false,
      readonlyDots: false,
      required: false,
   },
   argTypes: {
      disabled: { control: { type: 'boolean' } },
      hidden: { control: { type: 'boolean' } },
      readonly: { control: { type: 'boolean' } },
      readonlyDots: { control: { type: 'boolean' } },
      required: { control: { type: 'boolean' } },

      help: { control: { type: 'text' } },
      hint: { control: { type: 'text' } },
      label: { control: { type: 'text' } },
      name: { control: { type: 'text' } },
   },
} as ComponentMeta<typeof FieldLayout>;
