import React, { ReactNode } from 'react';

import { classNames } from '../../../../formatters';
import { isEmpty } from '../../../../helpers';
import { Hint } from '../../../../small_components';

import classes from './LabelHint.module.css';

export interface LabelHintProps {
   className?: string;
   forceHint?: boolean;
   hintClassName?: string;
   qa?: string;
   smallClassName?: string;
   text: ReactNode;
}

export const LabelHint: React.FC<LabelHintProps> = React.memo(
   ({ className, forceHint = false, qa, hintClassName, smallClassName, text }) => {
      if (isEmpty(text)) {
         return null;
      }

      if (!forceHint && typeof text === 'string' && text.length < 25) {
         return (
            <div className={classNames(classes.smallHint, smallClassName, className)} data-qa={qa}>
               {text}
            </div>
         );
      }

      return <Hint text={text} className={classNames(hintClassName, className)} qa={qa} />;
   },
);

LabelHint.displayName = 'LabelHint';
