import { ComponentMeta, Story } from '@storybook/react';
import React, { PropsWithChildren } from 'react';

import { FormAdvancedSection, FormAdvancedSectionProps } from './FormAdvancedSection';

const Template: Story<PropsWithChildren<FormAdvancedSectionProps>> = p => <FormAdvancedSection {...p} />;

export const Default = Template.bind({});
Default.args = {};

export const Opened = Template.bind({});
Opened.args = {
   openedByDefault: true,
};

export const WithTitle = Template.bind({});
WithTitle.args = {
   openedByDefault: true,
   title: 'Title of advanced settings',
};

export const WithCustomToggle = Template.bind({});
WithCustomToggle.args = {
   toggleText: '10/node',
   hasValue: true,
};

export default {
   args: {
      children: 'I am a body',
      header: 'I am a header',
   },
   argTypes: {
      children: { type: 'string' },
      header: { type: 'string' },
      title: { type: 'string' },
      toggleText: { type: 'string' },
   },
   component: FormAdvancedSection,
   title: 'forms2/components/FormAdvancedSection',
} as ComponentMeta<typeof FormAdvancedSection>;
