import { faGear as faCogSolid } from '@fortawesome/free-solid-svg-icons';
import { Card } from '@yandex-cloud/uikit';
import React, { ReactNode, useCallback, useEffect, useState } from 'react';

import { faGear as faCogEmpty } from '../../../_styles/@fortawesome/pro-regular-svg-icons';
import { classNames } from '../../../formatters';
import { FormButton } from '../index';

import classes from './FormAdvancedSection.module.css';

export interface FormAdvancedSectionProps {
   bodyClassName?: string;
   hasValue?: boolean;
   header: ReactNode;
   hideToggleSwitch?: boolean;
   openedByDefault?: boolean;
   title?: ReactNode;
   toggleText?: string;
   wrapperClassName?: string;
}

export const FormAdvancedSection: React.FC<FormAdvancedSectionProps> = React.memo(
   ({
      bodyClassName,
      children,
      hasValue = false,
      header,
      hideToggleSwitch = false,
      openedByDefault = false,
      title,
      toggleText = 'Advanced',
      wrapperClassName,
   }) => {
      const [opened, setOpened] = useState(openedByDefault);

      useEffect(() => {
         setOpened(openedByDefault);
      }, [openedByDefault]);

      const toggleOpened = useCallback(() => setOpened(o => !o), []);

      return (
         <div className={wrapperClassName}>
            <div className={classes.header} data-qa={'FormAdvancedSection:Header'}>
               {header}

               {!hideToggleSwitch && (
                  <FormButton
                     onClick={toggleOpened}
                     icon={hasValue ? faCogSolid : faCogEmpty}
                     skipLeftSpace={!header}
                     dataE2e={`FormAdvancedSection:${opened ? 'Hide' : 'Show'}ToggleButton`}
                  >
                     {toggleText}
                  </FormButton>
               )}
            </div>

            {opened ? (
               <div data-qa={'FormAdvancedSection:Body'}>
                  <Card view={'filled'} className={classNames(classes.body, bodyClassName)}>
                     {title ? (
                        <div className={classes.title} data-qa={'FormAdvancedSection:Title'}>
                           {title}
                        </div>
                     ) : null}
                     {children}
                  </Card>
               </div>
            ) : null}
         </div>
      );
   },
);

FormAdvancedSection.displayName = 'FormAdvancedSection';
