import { faHeart } from '@fortawesome/free-solid-svg-icons';
import { action } from '@storybook/addon-actions';
import { ComponentMeta, Story } from '@storybook/react';
import React, { PropsWithChildren } from 'react';

import { FormButton, FormButtonProps } from './FormButton';

const Template: Story<PropsWithChildren<FormButtonProps>> = ({ children, ...props }) => (
   <FormButton {...props}>{children}</FormButton>
);

export const Regular = Template.bind({});
Regular.args = {};

export const Disabled = Template.bind({});
Disabled.args = {
   children: 'Disabled button',
   disabled: true,
};

export const WithIcon = Template.bind({});
WithIcon.args = {
   icon: faHeart,
};

export const NoLeftSpace = Template.bind({});
NoLeftSpace.args = {
   icon: faHeart,
   skipLeftSpace: true,
};

export default {
   args: {
      children: 'Button text',
      onClick: action('onClick'),
   },
   component: FormButton,
   title: 'forms2/components/FormButton',
} as ComponentMeta<typeof FormButton>;
