import { IconDefinition } from '@fortawesome/fontawesome-svg-core';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button, ButtonView } from '@yandex-cloud/uikit';
import React, { SyntheticEvent } from 'react';

import { classNames, createE2eSelector } from '../../../formatters';

import classes from './FormButton.module.css';

export interface FormButtonProps {
   className?: string;
   dataE2e?: string;
   disabled?: boolean;
   icon?: IconDefinition;
   skipLeftSpace?: boolean;
   title?: string;
   view?: ButtonView;

   onClick(e: SyntheticEvent): void;
}

export const FormButton: React.FC<FormButtonProps> = ({
   children,
   className,
   dataE2e,
   disabled = false,
   icon,
   onClick,
   skipLeftSpace = false,
   view = 'flat-info',
   title,
}) => (
   <Button
      className={classNames(classes.button, className, { [classes.skipLeftSpace]: skipLeftSpace })}
      disabled={disabled}
      onClick={onClick}
      qa={createE2eSelector(dataE2e, title, typeof children === 'string' ? children : null, 'FormButton')}
      size={'s'}
      title={title}
      view={view}
   >
      {icon ? <FontAwesomeIcon icon={icon} className={classes.icon} /> : null}
      {children}
   </Button>
);

FormButton.displayName = 'FormButton';
