import { action } from '@storybook/addon-actions';
import { ComponentMeta, Story } from '@storybook/react';
import React from 'react';

import { FormCard, FormCardProps } from './FormCard';

const Template: Story<FormCardProps> = p => <FormCard {...p}>Body of the card</FormCard>;

export const Default = Template.bind({});
Default.args = {
   title: 'Card title',
   subTitle: 'Subtitle',
   hasRemoveButton: true,
   onRemove: action('onRemove'),
};

export default {
   argTypes: {
      title: { type: 'string' },
      subTitle: { type: 'string' },
   },
   component: FormCard,
   title: 'forms2/components/FormCard',
} as ComponentMeta<typeof FormCard>;
