import { useFormikContext } from 'formik';
import React, { useEffect } from 'react';

export interface FormChangeListenerProps {
   onChange(v: any): void;
}

/**
 * Обход ограничения Formik - невозможности слушать change формы
 */
export const FormChangeListener: React.FC<FormChangeListenerProps> = React.memo(({ onChange }) => {
   const form = useFormikContext();

   useEffect(() => {
      onChange(form.values);
   }, [form.values, onChange]);

   return null;
});

FormChangeListener.displayName = 'FormChangeListener';
