import { ComponentMeta, Story } from '@storybook/react';
import React, { PropsWithChildren } from 'react';

import { FormCollapsibleSection, FormCollapsibleSectionProps } from './FormCollapsibleSection';

const Template: Story<PropsWithChildren<FormCollapsibleSectionProps>> = p => <FormCollapsibleSection {...p} />;

export const Default = Template.bind({});
Default.args = {};

export const Opened = Template.bind({});
Opened.args = {
   openedByDefault: true,
};

export const WithTitle = Template.bind({});
WithTitle.args = {
   openedByDefault: true,
   title: 'Title of advanced settings',
};

export default {
   args: {
      children: 'I am a body',
      header: 'I am a header',
   },
   argTypes: {
      children: { type: 'string' },
      header: { type: 'string' },
      title: { type: 'string' },
      toggleText: { type: 'string' },
   },
   component: FormCollapsibleSection,
   title: 'forms2/components/FormCollapsibleSection',
} as ComponentMeta<typeof FormCollapsibleSection>;
