import { faChevronDown, faChevronUp } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Card } from '@yandex-cloud/uikit';
import React, { ReactNode, useCallback, useEffect, useState } from 'react';

import { classNames } from '../../../formatters';

import classes from './FormCollapsibleSection.module.css';

export interface FormCollapsibleSectionProps {
   bodyClassName?: string;
   header: ReactNode;
   headerClassName?: string;
   openedByDefault?: boolean;
   title?: ReactNode;
   wrapperClassName?: string;
}

export const FormCollapsibleSection: React.FC<FormCollapsibleSectionProps> = React.memo(
   ({ bodyClassName, children, headerClassName, openedByDefault = false, title, header, wrapperClassName }) => {
      const [opened, setOpened] = useState(openedByDefault);

      useEffect(() => {
         setOpened(openedByDefault);
      }, [openedByDefault]);

      const toggleOpened = useCallback(() => setOpened(o => !o), []);

      return (
         <div className={classNames(classes.wrapper, wrapperClassName)}>
            <button
               className={classNames(classes.headerBtn, { [classes.headerBtnOpened]: opened }, headerClassName)}
               onClick={toggleOpened}
               data-qa={`FormCollapsibleSection:${opened ? 'Hide' : 'Show'}ToggleButton`}
               type={'button'}
            >
               <span>{header}</span>
               <FontAwesomeIcon icon={opened ? faChevronUp : faChevronDown} className={classes.icon} />
            </button>

            {opened ? (
               <div data-qa={'FormCollapsibleSection:Body'}>
                  <Card view={'filled'} className={classNames(classes.body, bodyClassName)}>
                     {title ? (
                        <div className={classes.title} data-qa={'FormCollapsibleSection:Title'}>
                           {title}
                        </div>
                     ) : null}
                     {children}
                  </Card>
               </div>
            ) : null}
         </div>
      );
   },
);

FormCollapsibleSection.displayName = 'FormCollapsibleSection';
