import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import { Form, Formik } from 'formik';
import React from 'react';
import { object, string } from 'yup';

import { InputField } from '../../fields';

import { FormErrors } from './FormErrors';

const values = {
   id: '',
   name: '',
};

const validationSchema = object({
   id: string().required(),
   name: string().required(),
});

export const Regular = () => (
   <Formik
      initialValues={values}
      validationSchema={validationSchema}
      validateOnMount={true}
      onSubmit={action('onSubmit')}
      initialTouched={{ id: true, name: true }}
   >
      {() => (
         <Form>
            <InputField name={'id'} label={'ID'} />
            <InputField name={'name'} label={'Name'} />

            <FormErrors names={['id', 'name']} />
         </Form>
      )}
   </Formik>
);

export default {
   title: 'forms2/components/FormErrors',
} as Meta;
