import { useFormikContext } from 'formik';
import React, { Fragment, useMemo } from 'react';

import { FieldError } from '../FieldError/FieldError';

import classes from './FormErrors.module.css';

interface Props {
   hideEmpty?: boolean;
   names: string[];
}

export const FormErrors: React.FC<Props> = React.memo(({ names, hideEmpty = false }) => {
   const form = useFormikContext();

   const errors = useMemo(
      () =>
         names
            .map(name => form.getFieldMeta(name))
            .filter(meta => meta.error && meta.touched)
            .map(meta => meta.error),
      [form, names],
   );

   if (hideEmpty && errors.length === 0) {
      return null;
   }

   return (
      <div className={classes.wrapper}>
         {errors.map((error, i) => (
            // eslint-disable-next-line react/no-array-index-key
            <Fragment key={i}>
               <FieldError>{error as any}</FieldError>
               {i < errors.length - 1 ? <br /> : null}
            </Fragment>
         ))}
      </div>
   );
});

FormErrors.displayName = 'FormErrors';
