import { Meta, Story } from '@storybook/react';
import * as React from 'react';
import { FormikProps } from 'formik';

import { formikDecorator } from '../../../_storybook';
import { InputField } from '../../fields';
import { ExtendedFieldConfig } from '../../models';
import { DeclarativeFields } from '../DeclarativeFields/DeclarativeFields';

import { WarningPlateField } from './WarningPlateField';

import { warning } from './index';

export const Declarative: Story = () => {
   const fields: ExtendedFieldConfig[] = [
      {
         as: InputField,
         name: 'namespaceId',
         label: 'Namespace ID',
      },
      warning({
         label: 'Not found',
         name: 'warning',
         key: 'warning',
         content: 'Cannot find balancer phenotropili-test',
         warningPlateProps: {
            theme: 'danger',
            filled: false,
         },
      }),
   ];

   return <DeclarativeFields configs={fields} />;
};

export const CalculatedContent: Story = () => {
   const fields: ExtendedFieldConfig[] = [
      {
         as: InputField,
         name: 'namespaceId',
         label: 'Namespace ID',
      },
      warning({
         name: 'namespaceId',
         key: 'warning',
         content: (name, formValue: FormikProps<any>) =>
            !formValue.values[name] ? 'Value is empty' : 'Value is invalid',
         warningPlateProps: {
            theme: 'danger',
            filled: false,
         },
      }),
   ];

   return <DeclarativeFields configs={fields} />;
};

export const ReactWay: Story = () => {
   return (
      <>
         <InputField name={'namespaceId'} label={'Namespace ID'} />
         <WarningPlateField
            name={''}
            controlProps={{
               content: 'Components are not set fot this balancer',
               warningPlateProps: { theme: 'info' },
            }}
         />
      </>
   );
};

export default {
   decorators: [formikDecorator({})],
   title: 'forms2/components/WarningPlateField',
} as Meta;
