import React, { ReactNode } from 'react';

import { classNames } from '../../../formatters';
import { WarningPlate, WarningPlateProps } from '../../../small_components';
import { useCalculatedProp } from '../../helpers';
import { CalculatedProp, ExtendedFieldConfig } from '../../models';
import { FieldLayout } from '../FieldLayout/FieldLayout';

import classes from './WarningPlateField.module.css';

export interface WarningPlateFieldControlProps {
   content: CalculatedProp<ReactNode, any>;
   warningPlateProps?: WarningPlateProps;
}

export const WarningPlateField: React.FC<ExtendedFieldConfig<any, any, WarningPlateFieldControlProps>> = React.memo(
   props => {
      const { content, warningPlateProps } = props.controlProps ?? {};

      const children = useCalculatedProp(props.name, content);

      if (children === undefined) {
         return null;
      }

      return (
         <FieldLayout {...props} label={null}>
            <WarningPlate {...warningPlateProps} className={classNames(classes.plate, warningPlateProps?.className)}>
               {props.label && <span className={classes.title}>{props.label} </span>}
               {children}
            </WarningPlate>
         </FieldLayout>
      );
   },
);
