import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { WarningPlateField, WarningPlateFieldControlProps } from './WarningPlateField';

export { WarningPlateField } from './WarningPlateField';
export type { WarningPlateFieldControlProps } from './WarningPlateField';

export interface WarningPlateConfig<FV, V>
   extends Pick<ContainerConfig<FV, V>, 'fieldLayoutProps' | 'key' | 'label' | 'name'> {
   content: WarningPlateFieldControlProps['content'];
   warningPlateProps: WarningPlateFieldControlProps['warningPlateProps'];
}

export function warning<FormValue, V>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: WarningPlateConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, WarningPlateFieldControlProps> {
   return {
      ...fieldLayoutProps,
      as: WarningPlateField,
      controlProps,
      key,
      label,
      name,
   };
}
