import React from 'react';

import { DeclarativeFields, FieldLayout, FormAdvancedSection, FormAdvancedSectionProps } from '../../components';
import { ContainerControlProps, ExtendedFieldConfig } from '../../models';
import { ContainerWrapper } from '../../wrappers';

export interface AdvancedContainerControlProps extends ContainerControlProps {
   formAdvancedSectionProps?: Omit<FormAdvancedSectionProps, 'header'>;
}

export type AdvancedContainerProps = ExtendedFieldConfig<any, any, AdvancedContainerControlProps>;

export const AdvancedContainer: React.FC<AdvancedContainerProps> = React.memo(props => {
   const { fields, formAdvancedSectionProps } = props.controlProps ?? {};

   return (
      <FieldLayout {...props} label={null}>
         <ContainerWrapper {...props}>
            <FormAdvancedSection header={props.label} {...formAdvancedSectionProps}>
               {props.children ?? <DeclarativeFields configs={fields} />}
            </FormAdvancedSection>
         </ContainerWrapper>
      </FieldLayout>
   );
});

AdvancedContainer.displayName = 'AdvancedContainer';
