import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { AdvancedContainer, AdvancedContainerControlProps } from './AdvancedContainer';

export { AdvancedContainer } from './AdvancedContainer';

export interface AdvancedContainerConfig<FV, V> extends ContainerConfig<FV, V> {
   formAdvancedSectionProps?: AdvancedContainerControlProps['formAdvancedSectionProps'];
}

/**
 * Form section, hidden by default.
 *
 * User should click on button to open this section.
 */
export function advanced<FormValue = any, V = any>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: AdvancedContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, AdvancedContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: AdvancedContainer,
      controlProps,
      key,
      label,
      name,
   };
}
