import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import { Formik } from 'formik';
import * as React from 'react';

import { DeclarativeFields, DevFormValues } from '../../components';
import { InputField } from '../../fields';
import { ExtendedFieldConfig } from '../../models';

import { card, CardContainer, CardContainerConfig } from './index';

const formValues = {
   name: 'Tema',
   age: 22,
   work: {},
};

type FormValue = typeof formValues;

const internalFields: ExtendedFieldConfig<FormValue>[] = [
   { as: InputField, name: 'name', label: 'Name' },
   { as: InputField, name: 'age', label: 'Age', controlProps: { type: 'number' } },
];

type StoryProps = Omit<CardContainerConfig<FormValue, any>, 'key' | 'name' | 'fields'>;

const DeclarativeTemplate: Story<StoryProps> = config => {
   const fields: ExtendedFieldConfig<FormValue>[] = [
      card({
         ...config,
         key: 'card',
         name: 'card',
         fields: internalFields,
      }),
   ];

   return (
      <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <DeclarativeFields configs={fields} />
               <DevFormValues open={true} />
            </>
         )}
      </Formik>
   );
};

const ReactTemplate: Story<StoryProps> = config => (
   <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
      {() => (
         <>
            <CardContainer
               {...config.fieldLayoutProps}
               name={'card'}
               label={config.label}
               controlProps={{
                  cardProps: config.cardProps,
               }}
            >
               <DeclarativeFields configs={internalFields} />
            </CardContainer>
            <DevFormValues open={true} />
         </>
      )}
   </Formik>
);

export const DeclarativeStory = DeclarativeTemplate.bind({});

export const ReactStory = ReactTemplate.bind({});

export default {
   args: {
      cardProps: {},
      label: 'Label',
      namePrefix: '',
   },
   title: 'forms2/containers/CardContainer',
} as Meta<StoryProps>;
