import * as React from 'react';

import { DeclarativeFields, FieldLayout, FormCard, FormCardProps } from '../../components';
import { ContainerControlProps, ExtendedFieldConfig } from '../../models';
import { ContainerWrapper } from '../../wrappers';

export interface CardContainerControlProps extends ContainerControlProps {
   cardProps?: Partial<FormCardProps>;
}

export const CardContainer: React.FC<ExtendedFieldConfig<any, any, CardContainerControlProps>> = React.memo(props => {
   const { cardProps, fields } = props.controlProps ?? {};

   return (
      <FieldLayout {...props} label={null}>
         <ContainerWrapper {...props}>
            <FormCard title={props.label} {...cardProps}>
               <DeclarativeFields configs={fields} />
               {props.children}
            </FormCard>
         </ContainerWrapper>
      </FieldLayout>
   );
});

CardContainer.displayName = 'CardContainer';
