import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { CardContainer, CardContainerControlProps } from './CardContainer';

export { CardContainer } from './CardContainer';

export interface CardContainerConfig<FV, V> extends ContainerConfig<FV, V> {
   cardProps?: CardContainerControlProps['cardProps'];
}

export function card<FormValue = any, V = any>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: CardContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, CardContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: CardContainer,
      controlProps,
      key,
      label,
      name,
   };
}
