import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import { Formik } from 'formik';
import * as React from 'react';

import { DeclarativeFields, DevFormValues } from '../../components';
import { InputField } from '../../fields';
import { ExtendedFieldConfig } from '../../models';

import { collapsible, CollapsibleContainer, CollapsibleContainerConfig } from './index';

const formValues = {
   name: 'Tema',
   age: 22,
   work: {},
};

type FormValue = typeof formValues;

const internalFields: ExtendedFieldConfig<FormValue>[] = [
   { as: InputField, name: 'name', label: 'Name' },
   { as: InputField, name: 'age', label: 'Age', controlProps: { type: 'number' } },
];

type StoryProps = Omit<CollapsibleContainerConfig<FormValue, any>, 'key' | 'name' | 'fields'>;

const DeclarativeTemplate: Story<StoryProps> = config => {
   const fields: ExtendedFieldConfig<FormValue>[] = [
      { as: InputField, name: 'name', label: 'Name' },
      collapsible({
         ...config,
         key: 'advanced',
         name: 'advanced',
         fields: internalFields,
      }),
   ];

   return (
      <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <DeclarativeFields configs={fields} />
               <DevFormValues open={true} />
            </>
         )}
      </Formik>
   );
};

const ReactTemplate: Story<StoryProps> = ({ fieldLayoutProps, label, ...controlProps }) => (
   <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
      {() => (
         <>
            <InputField name={'name'} label={'Name'} />
            <CollapsibleContainer {...fieldLayoutProps} name={'advanced'} label={label} controlProps={controlProps}>
               <DeclarativeFields configs={internalFields} />
            </CollapsibleContainer>
            <DevFormValues open={true} />
         </>
      )}
   </Formik>
);

export const DeclarativeStory = DeclarativeTemplate.bind({});

export const ReactStory = ReactTemplate.bind({});

export default {
   args: {
      formCollapsibleSectionProps: {
         title: 'Title',
      },
      label: 'Advanced form',
      namePrefix: '',
      opened: (fieldName, form) => Boolean(form.values.name),
      preventNamePrefixing: true,
   },
   title: 'forms2/containers/CollapsibleContainer',
} as Meta<StoryProps>;
