import React from 'react';

import { DeclarativeFields, FieldLayout, FormCollapsibleSection, FormCollapsibleSectionProps } from '../../components';
import { useCalculatedProp } from '../../helpers';
import { CalculatedProp, ContainerControlProps, ExtendedFieldConfig } from '../../models';
import { ContainerWrapper } from '../../wrappers';

export interface CollapsibleContainerControlProps extends ContainerControlProps {
   formCollapsibleSectionProps?: Omit<FormCollapsibleSectionProps, 'header'>;
   opened?: CalculatedProp<boolean, any>;
}

export type CollapsibleContainerProps = ExtendedFieldConfig<any, any, CollapsibleContainerControlProps>;

export const CollapsibleContainer: React.FC<CollapsibleContainerProps> = React.memo(props => {
   const { fields, opened, formCollapsibleSectionProps } = props.controlProps ?? {};

   const actualOpened = useCalculatedProp(props.name, opened) ?? formCollapsibleSectionProps?.openedByDefault;

   return (
      <FieldLayout {...props} label={null}>
         <ContainerWrapper {...props}>
            <FormCollapsibleSection
               {...formCollapsibleSectionProps}
               openedByDefault={actualOpened}
               header={props.label}
            >
               {props.children ?? <DeclarativeFields configs={fields} />}
            </FormCollapsibleSection>
         </ContainerWrapper>
      </FieldLayout>
   );
});

CollapsibleContainer.displayName = 'CollapsibleContainer';
