import { CalculatedProp, ContainerConfig, ExtendedFieldConfig } from '../../models';

import { CollapsibleContainer, CollapsibleContainerControlProps } from './CollapsibleContainer';

export { CollapsibleContainer } from './CollapsibleContainer';

export interface CollapsibleContainerConfig<FV, V> extends ContainerConfig<FV, V> {
   formCollapsibleSectionProps?: CollapsibleContainerControlProps['formCollapsibleSectionProps'];
   opened?: CalculatedProp<boolean, any>;
}

/**
 * Form section, hidden by default.
 *
 * User should click on button to open this section.
 */
export function collapsible<FormValue = any, V = any>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: CollapsibleContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, CollapsibleContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: CollapsibleContainer,
      controlProps,
      key,
      label,
      name,
   };
}
