import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import { Formik } from 'formik';
import * as React from 'react';

import { DeclarativeFields, DevFormValues } from '../../components';
import { InputField } from '../../fields';
import { ExtendedFieldConfig } from '../../models';

import { fieldset, FieldsetContainer, FieldsetContainerConfig } from './index';

const formValues = {
   name: 'Tema',
   age: 22,
   work: {},
};

type FormValue = typeof formValues;

const internalFields: ExtendedFieldConfig<FormValue>[] = [
   { as: InputField, name: 'name', label: 'Name' },
   { as: InputField, name: 'age', label: 'Age', controlProps: { type: 'number' } },
];

type StoryProps = Omit<FieldsetContainerConfig<FormValue, any>, 'key' | 'name' | 'fields'>;

const DeclarativeTemplate: Story<StoryProps> = config => {
   const fields: ExtendedFieldConfig<FormValue>[] = [
      fieldset({
         ...config,
         key: 'fieldset',
         name: 'fieldset',
         fields: internalFields,
      }),
   ];

   return (
      <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <DeclarativeFields configs={fields} />
               <DevFormValues open={true} />
            </>
         )}
      </Formik>
   );
};

const ReactTemplate: Story<StoryProps> = config => (
   <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
      {() => (
         <>
            <FieldsetContainer {...config.fieldLayoutProps} name={'fieldset'} label={config.label}>
               <DeclarativeFields configs={internalFields} />
            </FieldsetContainer>
            <DevFormValues open={true} />
         </>
      )}
   </Formik>
);

export const DeclarativeStory = DeclarativeTemplate.bind({});

export const ReactStory = ReactTemplate.bind({});

export default {
   args: {
      label: 'Label',
   },
   title: 'forms2/containers/FieldsetContainer',
} as Meta<StoryProps>;
