import * as React from 'react';

import { DeclarativeFields, FieldLayout } from '../../components';
import { ContainerControlProps, ExtendedFieldConfig } from '../../models';
import { ContainerWrapper } from '../../wrappers';

export interface FieldsetContainerControlProps extends ContainerControlProps {}

export const FieldsetContainer: React.FC<ExtendedFieldConfig<any, any, FieldsetContainerControlProps>> = React.memo(
   props => {
      const { fields } = props.controlProps ?? {};

      return (
         <FieldLayout {...props} bigLabel={true}>
            <ContainerWrapper {...props}>
               <DeclarativeFields configs={fields} />
               {props.children}
            </ContainerWrapper>
         </FieldLayout>
      );
   },
);

FieldsetContainer.displayName = 'FieldsetContainer';
