import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { FieldsetContainer, FieldsetContainerControlProps } from './FieldsetContainer';

export { FieldsetContainer } from './FieldsetContainer';

export interface FieldsetContainerConfig<FV, V> extends ContainerConfig<FV, V> {}

export function fieldset<FormValue = any, V = any>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: FieldsetContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, FieldsetContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: FieldsetContainer,
      controlProps,
      key,
      label,
      name,
   };
}
