import * as React from 'react';

import { DeclarativeFields, FieldLayout } from '../../components';
import { ContainerControlProps, ExtendedFieldConfig } from '../../models';
import { ContainerWrapper, FieldOverrideWrapper } from '../../wrappers';

import classes from './RowContainer.module.css';

export interface RowContainerControlProps extends ContainerControlProps {}

export const RowContainer: React.FC<ExtendedFieldConfig<any, any, RowContainerControlProps>> = React.memo(props => {
   const { fields } = props.controlProps ?? {};

   return (
      <FieldLayout {...props} className={classes.field}>
         <ContainerWrapper {...props} className={classes.wrapper}>
            {props.children ? (
               <FieldOverrideWrapper className={classes.innerField}>{props.children}</FieldOverrideWrapper>
            ) : (
               <DeclarativeFields configs={fields} fieldClassName={classes.innerField} />
            )}
         </ContainerWrapper>
      </FieldLayout>
   );
});

RowContainer.displayName = 'RowContainer';
