import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { RowContainer, RowContainerControlProps } from './RowContainer';

export { RowContainer } from './RowContainer';

export interface RowContainerConfig<FV, V> extends ContainerConfig<FV, V> {}

export function row<FormValue = any, V = any>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: RowContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, RowContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: RowContainer,
      controlProps,
      key,
      label,
      name,
   };
}
