import { TabsDirection } from '@yandex-cloud/uikit';
import * as React from 'react';
import { ReactElement, useMemo } from 'react';

import { findChildren } from '../../../helpers';
import { SmartTab, SmartTabProps, SmartTabs } from '../../../small_components';
import { DeclarativeFields, FieldLayout } from '../../components';
import { ContainerControlProps, ExtendedFieldConfig } from '../../models';
import { ContainerWrapper, NamePrefixingWrapper } from '../../wrappers';

import { Tab, TabProps } from './Tab';
import classes from './TabsContainer.module.css';

export interface TabConfig extends Omit<SmartTabProps, '__ROLE' | 'children'> {
   fields: ExtendedFieldConfig[];
   name?: ExtendedFieldConfig['name'];
   preventNamePrefixing?: ContainerControlProps['preventNamePrefixing'];
}

export interface TabsContainerControlProps extends Omit<ContainerControlProps, 'fields'> {
   direction?: TabsDirection;
   tabConfigs?: TabConfig[];
}

export type TabsContainerProps = ExtendedFieldConfig<any, any, TabsContainerControlProps>;

const TabsContainerImpl: React.FC<TabsContainerProps> = React.memo(props => {
   const { direction, tabConfigs } = props.controlProps ?? {};
   const actualTabConfigs = useMemo(
      () => tabConfigs ?? findChildren(props.children, Tab).map(tab => (tab as ReactElement).props as TabProps),
      [props.children, tabConfigs],
   );

   return (
      <FieldLayout {...props}>
         <ContainerWrapper {...props}>
            <SmartTabs className={classes.wrapper} direction={direction}>
               {actualTabConfigs.map((tab: TabConfig | TabProps) => (
                  <SmartTab key={tab.id} {...tab}>
                     <NamePrefixingWrapper containerName={tab.name} preventNamePrefixing={tab.preventNamePrefixing}>
                        {(tab as TabProps).children ?? <DeclarativeFields configs={(tab as TabConfig).fields} />}
                     </NamePrefixingWrapper>
                  </SmartTab>
               ))}
            </SmartTabs>
         </ContainerWrapper>
      </FieldLayout>
   );
});

TabsContainerImpl.displayName = 'TabsContainer';

export const TabsContainer = Object.assign(TabsContainerImpl, {
   Tab,
});
