import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { TabsContainer, TabsContainerControlProps } from './TabsContainer';

export { TabsContainer } from './TabsContainer';

export interface TabsContainerConfig<FV, V> extends Omit<ContainerConfig<FV, V>, 'fields'> {
   direction?: TabsContainerControlProps['direction'];
   tabConfigs: TabsContainerControlProps['tabConfigs'];
}

export function tabs<FormValue = any, V = any>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: TabsContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, TabsContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: TabsContainer,
      controlProps,
      key,
      label,
      name,
   };
}
