import React from 'react';

import { BytesInput } from '../../form_inputs';
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig, RoundedInputControlProps } from '../models';

import classes from './BytesField.module.css';

export const BytesField = React.memo((props: ExtendedFieldConfig<any, number | null, RoundedInputControlProps>) => {
   const { field, onChange, readonly, disabled, onBlur, showError } = useExtendedField(props);

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         <BytesInput
            disabled={disabled}
            hasError={showError}
            name={field.name}
            onBlur={onBlur}
            onChange={onChange}
            placeholder={props.placeholder}
            qa={qa}
            readonly={readonly}
            readonlyClassName={classes.readonlyValue}
            useRenderDetails={props.controlProps?.useRenderDetails}
            value={field.value ?? null} // null на случай, если придёт undefined из формы
         />
      </FieldLayout>
   );
});

BytesField.displayName = 'BytesField';
