import { Checkbox } from '@yandex-cloud/uikit';
import React, { ReactNode, useCallback } from 'react';

import { styleHelpers } from '../../_styles/styleHelpers';
import { classNames } from '../../formatters';
import { isEmpty } from '../../helpers';
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig } from '../models';

import classes from './CheckboxField.module.css';

interface CheckboxFieldControlProps {
   children?: ReactNode;
   disableIndeterminate?: boolean;
}

export const CheckboxField = React.memo((props: ExtendedFieldConfig<any, boolean, CheckboxFieldControlProps>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   const indeterminate = props.controlProps?.disableIndeterminate ? false : isEmpty(field.value);

   // Почему-то стиль indeterminate применяется только для checked
   const checked = indeterminate || field.value;

   const onChangeFixed = useCallback(
      (v: boolean) => {
         // Приходится компенсировать, т.к. хочется, чтобы первое значение после indeterminate было true, а не false
         onChange(indeterminate ? true : v);
      },
      [onChange, indeterminate],
   );

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         <Checkbox
            checked={checked}
            className={classNames(classes.control, { [styleHelpers.commonError]: showError })}
            disabled={disabled || readonly}
            id={field.name}
            indeterminate={indeterminate}
            name={field.name}
            onBlur={onBlur}
            onUpdate={onChangeFixed}
            qa={qa}
            {...props.controlProps}
         >
            {props.controlProps?.children ?? props.children}
         </Checkbox>
      </FieldLayout>
   );
});

CheckboxField.displayName = 'CheckboxField';
