import React, { SyntheticEvent, useCallback } from 'react';

import { EMPTY_VALUE, NullableDate } from '../../_models';
import { styleHelpers } from '../../_styles/styleHelpers';
import { DateTimePicker } from '../../form_inputs';
import { classNames, formatDate } from '../../formatters';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig } from '../models';

import classes from './DateTimeField.module.css';

interface DateTimeControlProps {
   /**
    * Показывать контрол для редактирования времени прямо в поле DateTimeField
    */
   showTimeString?: boolean;

   /**
    * Для DateTimeField если true, то можно будет редактировать время
    */
   withTime?: boolean;
}

export const DateTimeField = React.memo((props: ExtendedFieldConfig<any, NullableDate, DateTimeControlProps>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   const showTime = Boolean(props.controlProps?.showTimeString);

   const onChangeFixed = useCallback((e: SyntheticEvent, v: Date | null) => onChange(v), [onChange]);

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         {readonly ? (
            <div className={classes.readonlyValue}>
               {field.value instanceof Date ? formatDate(field.value, showTime ? 'long' : 'short') : EMPTY_VALUE}
               <input type={'hidden'} name={field.name} value={field.value?.toISOString()} data-qa={qa} />
            </div>
         ) : (
            <DateTimePicker
               name={field.name}
               id={field.name}
               disabled={disabled}
               cls={classNames(classes.control, { [styleHelpers.commonError]: showError })}
               value={field.value ?? null}
               onChange={onChangeFixed}
               onBlur={onBlur}
               qa={qa}
               {...props.controlProps}
            />
         )}
      </FieldLayout>
   );
});

DateTimeField.displayName = 'DateTimeField';
