import React from 'react';

import { DurationInput, DurationMsInput } from '../../form_inputs';
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig, RoundedInputControlProps } from '../models';

import classes from './DurationField.module.css';

export interface DurationFieldControlProps extends RoundedInputControlProps {
   useMilliseconds?: boolean;
}

export const DurationField = React.memo((props: ExtendedFieldConfig<any, number | null, DurationFieldControlProps>) => {
   const { field, onChange, readonly, disabled, onBlur, showError } = useExtendedField(props);

   const useMilliseconds = props.controlProps?.useMilliseconds ?? false;
   const InputComponent = useMilliseconds ? DurationMsInput : DurationInput;

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         <InputComponent
            disabled={disabled}
            hasError={showError}
            name={field.name}
            onBlur={onBlur}
            onChange={onChange}
            placeholder={props.placeholder}
            readonly={readonly}
            readonlyClassName={classes.readonlyValue}
            useRenderDetails={props.controlProps?.useRenderDetails}
            value={field.value ?? null} // null на случай, если придёт undefined из формы
            qa={qa}
         />
      </FieldLayout>
   );
});

DurationField.displayName = 'DurationField';
