import { ControlGroupOption } from '@yandex-cloud/uikit';
import React, { useMemo } from 'react';

import { EnumOption } from '../../_models';
import { EnumSwitcher } from '../../form_inputs';
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig } from '../models';

import classes from './EnumField.module.css';

interface EnumControlProps {
   /**
    * Декларативный способ передать варианты для выбора в EnumField
    */
   options?: EnumOption[];
}

export const EnumField = React.memo((props: ExtendedFieldConfig<any, string, EnumControlProps>) => {
   const { disabled, field, readonly, showError, onChange, onBlur } = useExtendedField(props);

   const { enumOptions, controlProps } = useMemo((): {
      enumOptions: ControlGroupOption[];
      controlProps: Partial<EnumControlProps>;
   } => {
      if (!props.controlProps) {
         return { enumOptions: [], controlProps: {} };
      }

      const { options, ...restControlProps } = props.controlProps;

      return {
         enumOptions: (options ?? []).map(o => ({
            value: o.value,
            content: o.title,
         })),
         controlProps: restControlProps,
      };
   }, [props.controlProps]);

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         <EnumSwitcher
            disabled={disabled}
            hasError={Boolean(showError)}
            name={field.name}
            onBlur={onBlur}
            onChange={onChange}
            options={enumOptions}
            readonly={readonly}
            readonlyClassName={classes.readonlyValue}
            value={field.value}
            qa={qa}
            {...controlProps}
         >
            {props.children}
         </EnumSwitcher>
      </FieldLayout>
   );
});

EnumField.displayName = 'EnumField';
