import React from 'react';

import { EMPTY_VALUE } from '../../_models';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig } from '../models';

export interface ReadonlyControlProps {
   /**
    * Преобразует значение перед рендерингом. Для ReadonlyField
    */
   valueFormat?: (v: any) => any;
}

export const ReadonlyField = React.memo((props: ExtendedFieldConfig<any, any, ReadonlyControlProps>) => {
   const { field } = useExtendedField(props);

   let { value } = field;

   if (props.controlProps && props.controlProps.valueFormat) {
      value = props.controlProps.valueFormat(value);
   }

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         {value || EMPTY_VALUE}
         <input type={'hidden'} name={field.name} value={value} data-qa={qa} />
      </FieldLayout>
   );
});

ReadonlyField.displayName = 'ReadonlyField';
