import React from 'react';

import { SetValuesInput } from '../../form_inputs';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig } from '../models';

import classes from './SetField.module.css';

interface SetControlProps {
   separator?: RegExp;
   type?: 'string' | 'number';
}

export const SetField = React.memo((props: ExtendedFieldConfig<any, Set<string> | Set<number>, SetControlProps>) => {
   const { field, readonly, disabled, onBlur, onChange, showError } = useExtendedField(props);
   const type = props.controlProps?.type === 'number' ? 'number' : 'string';

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         <SetValuesInput
            id={field.name}
            name={field.name}
            type={type}
            value={field.value}
            onChange={onChange}
            onBlur={onBlur}
            className={classes.control}
            readonlyClassName={classes.readonlyValue}
            hasError={showError}
            placeholder={props.placeholder}
            readonly={readonly}
            disabled={disabled}
            qa={qa}
            {...(props.controlProps as any)}
         />
      </FieldLayout>
   );
});

SetField.displayName = 'SetField';
