import React, { SyntheticEvent, useCallback } from 'react';

import { EMPTY_VALUE } from '../../_models';
import { styleHelpers } from '../../_styles/styleHelpers';
import { classNames } from '../../formatters';
import { EntityId, ISuggestBaseEntity, ISuggestStrategy, SuggestLayer, SuggestSelect } from '../../suggestions';
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig } from '../models';

import classes from './InputField.module.css';

interface SuggestSelectControlProps {
   layer: SuggestLayer | string;
   strategy?: ISuggestStrategy;
}

export const SuggestSelectField: React.FC<ExtendedFieldConfig<any, EntityId, SuggestSelectControlProps>> = props => {
   const { field, disabled, readonly, showError, onChange, onBlur } = useExtendedField<EntityId>(props);

   const onSelect = useCallback(
      (e: SyntheticEvent | null, item: ISuggestBaseEntity | null) => {
         onChange(item?.id ?? null);
      },
      [onChange],
   );

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         {readonly ? (
            <div className={classes.readonlyValue}>
               {field.value ?? EMPTY_VALUE}
               <input type={'hidden'} name={field.name} value={field.value?.toString()} />
            </div>
         ) : (
            <SuggestSelect
               clearOnSelect={false}
               cls={classNames(classes.control, { [styleHelpers.commonError]: showError })}
               disabled={disabled}
               entityId={field.value}
               onBlur={onBlur}
               onSelect={onSelect}
               resolveItemOnInit={true}
               qa={qa}
               {...props.controlProps}
            />
         )}
      </FieldLayout>
   );
};
