import { Switch } from '@yandex-cloud/uikit';
import React, { useCallback } from 'react';

import { classNames } from '../../formatters';
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig } from '../models';

import classes from './SwitcherField.module.css';

export const SwitcherField = React.memo((props: ExtendedFieldConfig<any, boolean, {}>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   const onChangeFixed = useCallback(() => onChange(!field.value), [field.value, onChange]);

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         <Switch
            disabled={disabled || readonly}
            className={classNames(classes.control, { [classes.error]: showError })}
            name={field.name}
            checked={field.value}
            onChange={onChangeFixed}
            onBlur={onBlur}
            qa={qa}
            {...props.controlProps}
         >
            {props.children}
         </Switch>
      </FieldLayout>
   );
});

SwitcherField.displayName = 'SwitcherField';
