import React from 'react';

import { EMPTY_VALUE } from '../../_models';
import { styleHelpers } from '../../_styles/styleHelpers';
import { AutoGrowTextArea, AutoGrowTextAreaProps } from '../../form_inputs';
import { classNames } from '../../formatters';
import { Rows } from '../../small_components';
import { FieldLayout } from '../components';
import { useExtendedField } from '../helpers';
import { ExtendedFieldConfig } from '../models';

import classes from './TextField.module.css';

export interface TextControlProps extends AutoGrowTextAreaProps {
   monospaceFont?: boolean;
   readonlyPre?: boolean;
}

export const TextField = React.memo((props: ExtendedFieldConfig<any, string, TextControlProps>) => {
   const { field, readonly, disabled, onBlur, onChange, showError } = useExtendedField(props);
   const { monospaceFont, readonlyPre } = props.controlProps ?? {};

   const qa = props.qa ?? props.name.toString();

   return (
      <FieldLayout {...props}>
         {readonly ? (
            <>
               {readonlyPre ? (
                  <pre className={classes.readonlyPre}>{field.value}</pre>
               ) : (
                  <div className={classes.readonlyDiv}>
                     <Rows text={field.value || EMPTY_VALUE} />
                  </div>
               )}
               <input type={'hidden'} name={field.name} value={field.value} />
            </>
         ) : (
            <AutoGrowTextArea
               className={classNames(classes.control, {
                  [styleHelpers.commonError]: showError,
                  [classes.monospace]: monospaceFont,
               })}
               disabled={disabled}
               hasClear={true}
               id={field.name}
               name={field.name}
               onBlur={onBlur}
               onUpdate={onChange}
               placeholder={props.placeholder}
               value={field.value}
               qa={qa}
               {...props.controlProps}
            />
         )}
      </FieldLayout>
   );
});

TextField.displayName = 'TextField';
