import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import { Formik } from 'formik';
import * as React from 'react';

import { DeclarativeFields, DevFormValues } from '../../components';
import { InputField } from '../../fields';
import { ExtendedFieldConfig } from '../../models';

import { cards, CardsListContainer, CardsListContainerConfig } from './index';

const formValues = {
   name: 'Tema',
   age: 22,
   workplaces: [{ companyName: 'Encraft', years: 8 }],
};

type FormValue = typeof formValues;

const internalFields: ExtendedFieldConfig<FormValue>[] = [
   { as: InputField, name: 'name', label: 'Name' },
   { as: InputField, name: 'age', label: 'Age', controlProps: { type: 'number' } },
];

const workplaceFields = [
   {
      as: InputField,
      name: 'companyName',
      label: 'Company Name',
   },
   {
      as: InputField,
      name: 'years',
      label: 'Years',
      controlProps: { type: 'number' },
   },
];

type StoryProps = Omit<CardsListContainerConfig<FormValue, any[]>, 'key' | 'name' | 'fields'>;

const DeclarativeTemplate: Story<StoryProps> = config => {
   const fields: ExtendedFieldConfig<FormValue>[] = [
      ...internalFields,
      cards({
         ...config,
         addButtonText: config.addButtonText,
         fields: workplaceFields,
         keepAtLeastOne: config.keepAtLeastOne,
         key: 'workplaces',
         labelPosition: 'top',
         name: 'workplaces',
      }),
   ];

   return (
      <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <DeclarativeFields configs={fields} />
               <DevFormValues open={true} />
            </>
         )}
      </Formik>
   );
};

const ReactTemplate: Story<StoryProps> = config => (
   <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
      {() => (
         <>
            <DeclarativeFields configs={internalFields} />
            <CardsListContainer
               {...config.fieldLayoutProps}
               name={'skills'}
               label={config.label}
               controlProps={{
                  addButtonText: config.addButtonText,
                  fields: workplaceFields,
                  getCardTitle: config.getCardTitle,
                  keepAtLeastOne: config.keepAtLeastOne,
               }}
            />
            <DevFormValues open={true} />
         </>
      )}
   </Formik>
);

export const DeclarativeStory = DeclarativeTemplate.bind({});

export const ReactStory = ReactTemplate.bind({});

export default {
   args: {
      addButtonText: 'Add workplace',
      getCardTitle: r => r.companyName,
      keepAtLeastOne: false,
      label: 'Workplaces',
      preventNamePrefixing: false,
   },
   title: 'forms2/listContainers/CardsListContainer',
} as Meta<StoryProps>;
